﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace WPF.PresentationLayer.Behaviors
{
    public static class MouseSingleDoubleClick
    {
        #region IsEnabled Property

        public static bool GetIsEnabled(DependencyObject frameworkElement)
        {
            if (frameworkElement == null)
            {
                return false;
            }
            return (bool)frameworkElement.GetValue(IsEnabledProperty);
        }

        public static void SetIsEnabled(DependencyObject frameworkElement, bool value)
        {
            if (frameworkElement == null)
            {
                return;
            }
            frameworkElement.SetValue(IsEnabledProperty, value);
        }

        #endregion //IsEnabled Property

        public static readonly DependencyProperty IsEnabledProperty = DependencyProperty.RegisterAttached(
                    "IsEnabled",
                    typeof(bool),
                    typeof(MouseSingleDoubleClick),
                    new FrameworkPropertyMetadata(IsSingleDoubleClickEnabled));


        private static void IsSingleDoubleClickEnabled(DependencyObject target, DependencyPropertyChangedEventArgs e)
        {
            Control control = target as Control;
            if (control != null && target != null)
            {
                bool isEnabled = (bool)control.GetValue(IsEnabledProperty);

                if (isEnabled )
                {
                    control.PreviewMouseDoubleClick += OnPreviewMouseDoubleClick;
                }
                else
                {
                    control.PreviewMouseDoubleClick -= OnPreviewMouseDoubleClick;
                }
            }
        }

        private static void OnPreviewMouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            e.Handled = true;
        }
    }

}
